/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.message;

import filenet.vw.apps.taskman.VWTaskCellRenderer;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.message.VWConsoleEvent;
import filenet.vw.apps.taskman.message.VWConsoleListener;
import filenet.vw.apps.taskman.message.VWConsoleMsg;
import filenet.vw.apps.taskman.message.VWConsoleMsgContextMenu;
import filenet.vw.apps.taskman.message.VWConsoleMsgDialog;
import filenet.vw.apps.taskman.message.VWConsoleMsgOptionsDialog;
import filenet.vw.apps.taskman.message.VWConsoleMsgTableModel;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableColumn;

public class VWConsoleMsgPanel
extends JPanel
implements IVWMouseActionListener,
KeyListener {
    private EventListenerList m_listenerList = new EventListenerList();
    private VWTaskCore m_taskCore = null;
    private Frame m_parentFrame = null;
    private VWConsoleMsgTableModel m_tableModel = null;
    private VWConsoleMsgDialog m_msgDialog = null;
    private VWTable m_table = null;
    private Object[] m_items = null;
    private Level m_messageLevel = Level.INFO;
    private static Robot robot = null;

    public VWConsoleMsgPanel(Frame parentFrame, VWTaskCore taskCore) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_taskCore = taskCore;
            this.setLayout(new BorderLayout());
            this.createTable();
            this.add((Component)new JScrollPane(this.m_table, 22, 30), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void writeMessage(final Level level, final String message, final String sourceName, final Icon sourceIcon) {
        if (level != null && level.intValue() >= this.m_messageLevel.intValue()) {
            Runnable runner = new Runnable(){

                public void run() {
                    VWConsoleMsgPanel.this.m_tableModel.addMessage(new VWConsoleMsg(level, new Date(), message, sourceName, sourceIcon));
                    VWConsoleMsgPanel.this.m_tableModel.fireTableDataChanged();
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    public void clear() {
        this.m_tableModel.clear();
        this.m_tableModel.fireTableDataChanged();
    }

    public void showOptionsDialog() throws Exception {
        VWConsoleMsgOptionsDialog dialog = new VWConsoleMsgOptionsDialog(this.m_parentFrame, this.m_messageLevel, this.m_tableModel.getMaxMessages());
        dialog.setVisible(true);
        if (dialog.getUserChoice() == 0) {
            this.setMessageLevel(dialog.getMessageLevel());
            this.setMaxMessages(dialog.getMaxMessages());
            try {
                this.m_taskCore.updateApplicationFile();
            }
            catch (Exception e) {
                VWDebug.logError(e.getLocalizedMessage());
            }
        }
        dialog.dispose();
    }

    public void setMessageLevel(Level messageLevel) {
        this.m_messageLevel = messageLevel;
        this.fireConsoleLevelChangedEvent(new VWConsoleEvent((Object)this, this.m_messageLevel));
    }

    public Level getMessageLevel() {
        return this.m_messageLevel;
    }

    public void setMaxMessages(int maxMessages) {
        this.m_tableModel.setMaxMessages(maxMessages);
    }

    public int getMaxMessages() {
        return this.m_tableModel.getMaxMessages();
    }

    public void doubleClickedItem(MouseEvent event) {
        Point pt = null;
        int nRowIndex = -1;
        int nColumnIndex = -1;
        VWConsoleMsg message = null;
        try {
            if (this.m_table == null || this.m_tableModel == null) {
                return;
            }
            pt = event.getPoint();
            nRowIndex = this.m_table.rowAtPoint(pt);
            nColumnIndex = this.m_table.columnAtPoint(pt);
            if (nRowIndex == -1 || nColumnIndex == -1) {
                return;
            }
            message = this.m_tableModel.getMessageAt(nRowIndex);
            if (this.m_msgDialog == null) {
                this.m_msgDialog = new VWConsoleMsgDialog(this.m_parentFrame);
            }
            if (message != null) {
                this.m_msgDialog.displayMessage(message);
            }
        }
        catch (Exception ex) {
            this.m_taskCore.displayError(ex);
        }
    }

    public void createPopup(MouseEvent evt) {
        Object obj = evt.getSource();
        Point p = evt.getPoint();
        VWConsoleMsgContextMenu contextMenu = new VWConsoleMsgContextMenu(this.m_taskCore.getMenuBar());
        VWTaskUtil.updateComponentOrientation(contextMenu);
        contextMenu.show((VWTable)obj, p.x, p.y);
    }

    public void addVWConsoleListener(VWConsoleListener listener) {
        this.m_listenerList.add(VWConsoleListener.class, listener);
    }

    public void removeVWConsoleListener(VWConsoleListener listener) {
        this.m_listenerList.remove(VWConsoleListener.class, listener);
    }

    private void createTable() {
        this.m_table = new VWTable();
        this.m_table.setShowGrid(false);
        this.m_tableModel = new VWConsoleMsgTableModel();
        this.m_table.setModel(this.m_tableModel);
        this.m_table.addMouseListener(new VWMouseAdapter(this));
        this.m_table.setDefaultRenderer(Icon.class, new VWTaskCellRenderer());
        this.m_table.setDefaultRenderer(VWConsoleMsg.class, new VWTaskCellRenderer());
        this.m_table.setDefaultRenderer(Date.class, new VWTaskCellRenderer());
        this.m_table.addKeyListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.ConsoleMessageTable, VWResource.ConsoleMessageTable);
        this.m_table.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (VWConsoleMsgPanel.this.m_table == null || VWConsoleMsgPanel.this.m_table.getModel() == null || VWConsoleMsgPanel.this.m_table.getRowCount() == 0) {
                    FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
        int nColWidth = 0;
        TableColumn aColumn = this.m_table.getColumn(this.m_table.getColumnName(0));
        try {
            nColWidth = Integer.parseInt("20");
        }
        catch (Exception ex) {
            nColWidth = 20;
        }
        aColumn.setMaxWidth(nColWidth);
        aColumn.setMinWidth(nColWidth);
        aColumn = this.m_table.getColumn(this.m_table.getColumnName(1));
        try {
            nColWidth = Integer.parseInt("250");
        }
        catch (Exception ex) {
            nColWidth = 250;
        }
        aColumn.setMaxWidth(nColWidth);
        try {
            nColWidth = Integer.parseInt("150");
        }
        catch (Exception ex) {
            nColWidth = 150;
        }
        aColumn.setMinWidth(nColWidth);
        aColumn = this.m_table.getColumn(this.m_table.getColumnName(3));
        try {
            nColWidth = Integer.parseInt("170");
        }
        catch (Exception ex) {
            nColWidth = 175;
        }
        aColumn.setMaxWidth(nColWidth);
        aColumn.setMinWidth(nColWidth);
        this.m_tableModel.fireTableDataChanged();
    }

    private void fireConsoleLevelChangedEvent(VWConsoleEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VWConsoleListener.class) continue;
            ((VWConsoleListener)listeners[i + 1]).consoleLevelChanged(event);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 121: {
                int modifiers = event.getModifiers();
                if ((modifiers & 1) == 0) break;
                robot.keyPress(27);
                robot.keyRelease(27);
                if (this.m_table == null) break;
                int selectedRow = this.m_table.getSelectedRow();
                int selectedCol = this.m_table.getSelectedColumn();
                Rectangle rect = this.m_table.getCellRect(selectedRow, selectedCol, true);
                VWConsoleMsgContextMenu contextMenu = new VWConsoleMsgContextMenu(this.m_taskCore);
                VWTaskUtil.updateComponentOrientation(contextMenu);
                contextMenu.show(this.m_table, rect.x + rect.width, rect.y);
                this.dispatchEvent(new KeyEvent(contextMenu, 401, System.currentTimeMillis(), 0, 40));
                break;
            }
            case 10: {
                if (this.m_table == null) break;
                int selectedRow = this.m_table.getSelectedRow();
                try {
                    VWConsoleMsg message = this.m_tableModel.getMessageAt(selectedRow);
                    if (this.m_msgDialog == null) {
                        this.m_msgDialog = new VWConsoleMsgDialog(this.m_parentFrame);
                    }
                    if (message == null) break;
                    this.m_msgDialog.displayMessage(message);
                    break;
                }
                catch (Exception ex) {
                    this.m_taskCore.displayError(ex);
                }
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    robot = new Robot();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

